//=============================================================================
// PB ScoreBoard
//=============================================================================
class PBSB extends TournamentScoreBoard;

var localized string TeamName[4];
var localized string OrdersString, InString;
var localized string PlayersNotShown;
var() color TeamColor[4];
var() color AltTeamColor[4];
var PlayerReplicationInfo OwnerInfo;
var TournamentGameReplicationInfo OwnerGame;
var PBPRI Ordered[32];

function ShowScores( canvas Canvas )
{
	local PBPRI PRI;
	local int PlayerCount, i;
	local float LoopCountTeam[4];
	local float XL, YL, XOffset, Ypos, Xpos, bckYlength;
	local int PlayerCounts[4];
	local int LongLists[4];
	local int BottomSlot[4];
	local font CanvasFont;
	local bool bCompressed;
	local float r;

	OwnerInfo = Pawn(Owner).PlayerReplicationInfo;
	OwnerGame = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);	
	CanvasFont = Canvas.Font;

	// Header
	DrawHeader(Canvas);

	for ( i=0; i<32; i++ )
		Ordered[i] = None;

	for ( i=0; i<32; i++ )
	{
		if (PlayerPawn(Owner).GameReplicationInfo.PRIArray[i] != None)
		{
			PRI = PBPRI(PlayerPawn(Owner).GameReplicationInfo.PRIArray[i]);
			if ( !PRI.bIsSpectator || PRI.bWaitingPlayer )
			{
				Ordered[PlayerCount] = PRI;
				PlayerCount++;
				PlayerCounts[PRI.Team]++;
			}
		}
	}

	SortScores(PlayerCount);
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.StrLen("TEXT", XL, YL);
	Xpos = Canvas.ClipX * 0.5 - 256;
	Ypos = 128 + YL*2;
	bckYlength = PlayerCount * YL;

	//Draw Frames and backgrounds:
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Xpos - 2, Ypos - 2);
	Canvas.DrawTile(Texture'PopBalloonsTextures.Colors.cWhite', 516, 2, 0, 0, 2.0, 2.0);
	Canvas.SetPos(Xpos - 2, Ypos );
	Canvas.DrawTile(Texture'PopBalloonsTextures.Colors.cWhite', 2, YL, 0, 0, 2.0, 2.0);
	Canvas.SetPos(Xpos + 512, Ypos );
	Canvas.DrawTile(Texture'PopBalloonsTextures.Colors.cWhite', 2, YL, 0, 0, 2.0, 2.0);
	Canvas.SetPos(Xpos - 2, Ypos + YL);
	Canvas.DrawTile(Texture'PopBalloonsTextures.Colors.cWhite', 516, 2, 0, 0, 2.0, 2.0);
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Xpos, Ypos);
	Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.BluePaletteA', 512, YL, 0, 0, 256.0, 4.0);
	Canvas.SetPos(Xpos - 2, Ypos + YL );
	Canvas.DrawTile(Texture'PopBalloonsTextures.Colors.cWhite', 2, bckYlength, 0, 0, 2.0, 2.0);
	Canvas.SetPos(Xpos + 512, Ypos + YL );
	Canvas.DrawTile(Texture'PopBalloonsTextures.Colors.cWhite', 2, bckYlength, 0, 0, 2.0, 2.0);
	Canvas.SetPos(Xpos - 2, Ypos + YL + bckYlength);
	Canvas.DrawTile(Texture'PopBalloonsTextures.Colors.cWhite', 516, 2, 0, 0, 2.0, 2.0);
	Canvas.SetPos(Xpos, Ypos + YL);
	Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.BluePaletteB', 512, bckYlength, 0, 0, 4.0, 256.0);
	
	Canvas.Style = ERenderStyle.STY_Normal;
	
	Canvas.DrawColor = GreenColor * 0.1;
	Canvas.SetPos(Xpos + 1, Ypos + 1);
	Canvas.DrawText("Player:", False);
	Canvas.SetPos(Xpos + 256 + 1, Ypos + 1);
	Canvas.DrawText("Score", False);
	Canvas.SetPos(Xpos + 384 + 1, Ypos + 1);
	Canvas.DrawText("Rank", False);
	Canvas.DrawColor = GreenColor;
	Canvas.SetPos(Xpos, Ypos);
	Canvas.DrawText("Player:", False);
	Canvas.SetPos(Xpos + 256, Ypos);
	Canvas.DrawText("Score", False);
	Canvas.SetPos(Xpos + 384, Ypos);
	Canvas.DrawText("Rank", False);
	 
	for ( I=0; I<PlayerCount; I++ )
		{
		Ypos += YL;
		Canvas.DrawColor = GoldColor * 0.1;
		Canvas.SetPos(Xpos + 1, Ypos + 1);
		Canvas.DrawText(Ordered[I].PlayerName, False);
		Canvas.SetPos(Xpos + 256 + 1, Ypos + 1);
		Canvas.DrawText(int(Ordered[I].Score), False);
		Canvas.SetPos(Xpos + 384 + 1, Ypos + 1);
		Canvas.DrawText(int(Ordered[I].Rank), False);
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(Xpos, Ypos);
		Canvas.DrawText(Ordered[I].PlayerName, False);
		Canvas.SetPos(Xpos + 256, Ypos);
		Canvas.DrawText(int(Ordered[I].Score), False);
		Canvas.SetPos(Xpos + 384, Ypos);
		Canvas.DrawText(int(Ordered[I].Rank), False);
		}

	

	// Trailer
	if ( !Level.bLowRes )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		DrawTrailer(Canvas);
	}
	Canvas.Font = CanvasFont;
	Canvas.DrawColor = WhiteColor;
}

function SortScores(int N)
{
local int I, J, Max;
local PBPRI TempPRI;
local PBPRI PRI;
	
	for ( I=0; I<N-1; I++ )
		{
		Max = I;
		for ( J=I+1; J<N; J++ )
			{
			if ( Ordered[J].Rank > Ordered[Max].Rank )
				Max = J;
			else if ((Ordered[J].Rank == Ordered[Max].Rank) && (Ordered[J].Score < Ordered[Max].Score))
				Max = J;
			else if ((Ordered[J].Rank == Ordered[Max].Rank) && (Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].PlayerID < Ordered[Max].Rank))
				Max = J;
			}

		TempPRI = Ordered[Max];
		Ordered[Max] = Ordered[I];
		Ordered[I] = TempPRI;
		}
}

function DrawVictoryConditions(Canvas Canvas)
{
	local TournamentGameReplicationInfo TGRI;
	local float X, Scale;

	TGRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	if ( TGRI == None )
		return;

	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Masked;
	if ( Canvas.ClipX < 1024 )
		Scale = Canvas.ClipX / 1024;
	else
		Scale = 1;
	X = 512 * Scale;
	Canvas.SetPos(Canvas.ClipX * 0.5 - X, 10);
	Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.PB_Logo', 1024 * Scale, 128 * Scale, 0, 0, 1024.0, 128.0);
	Canvas.Style = ERenderStyle.STY_Normal;
}

defaultproperties
{
     TeamName(0)="Red Team"
     TeamName(1)="Blue Team"
     TeamName(2)="Green Team"
     TeamName(3)="Gold Team"
     OrdersString="Orders:"
     InString="Location:"
     PlayersNotShown="Player[s] not shown."
     TeamColor(0)=(R=255)
     TeamColor(1)=(G=128,B=255)
     TeamColor(2)=(G=255)
     TeamColor(3)=(R=255,G=255)
     AltTeamColor(0)=(R=200)
     AltTeamColor(1)=(G=94,B=187)
     AltTeamColor(2)=(G=128)
     AltTeamColor(3)=(R=255,G=255,B=128)
}
